#include <bits/stdc++.h>
#define ll long long

using namespace std;

const int mxN = 4e3+200;
int n, c, q, arr[mxN+10];

int lazy[2*mxN+10];
array<int, 2> tree[2*mxN+10];

int MyLog(int a){

    int log = 0;
    while (a){
        a /= 2;
        log++;
    }
    return log-1;
}

void Update1(int a, int b, int k, int x, int y){

    if (b < x || a > y) return;

    if (a <= x && b >= y)
        lazy[k] = 1;

    if (lazy[k]){
        int t = tree[k][0];
        tree[k][0] = tree[k][1] - t;
        lazy[k] = 0;
        if (2*k >= n && k < n){
            tree[2*k][0] = 1-tree[2*k][0];
            tree[2*k+1][0] = 1-tree[2*k+1][0];
        }
        else
            lazy[2*k] = lazy[2*k+1] = 1;
    }

    if (!(a <= x && b >= y)){
        int m = (x + y) / 2;
        Update1(a, b, 2*k, x, m);
        Update1(a, b, 2*k+1, m+1, y);
    }
    if (!lazy[2*k] && !lazy[2*k+1])
        tree[k][0] = tree[2*k][0] + tree[2*k+1][0];
}

int Create1(int k, int d){

    tree[k][1] = d;
    if (k >= n)
        return tree[k][0] = arr[k-n];
    return tree[k][0] = Create1(2*k, d / 2) + Create1(2*k+1, d / 2);
}

void SolveForCN(){

    int t = MyLog(n);
    if ((int)pow(2, t)^n)
        while ((int)pow(2, t+1)^n)
            arr[n++] = 0;

    Create1(1, n);

    for (int i = 0; i < q; i++){
        int l, r;
        cin >> l >> r;
        --l, --r;
        Update1(l, r, 1, 0, n-1);
        cout << tree[1][0] << '\n';
    }
}


void Update2(int a, int b, int k, int x, int y){

    if (b < x || a > y) return;

    if (a <= x && b >= y)
        lazy[k] = 1;

    if (lazy[k]){
        int t = tree[k][0];
        tree[k][0] = tree[k][1] - t;
        lazy[k] = 0;
        if (2*k >= n && k < n){
            tree[2*k][0] = 1-tree[2*k][0];
            tree[2*k+1][0] = 1-tree[2*k+1][0];
        }
        else
            lazy[2*k] = lazy[2*k+1] = 1;
    }

    int m = (x + y) / 2;
    if (!(a <= x && b >= y)){
        Update2(a, b, 2*k, x, m);
        Update2(a, b, 2*k+1, m+1, y);
    }

    if (!lazy[2*k] && !lazy[2*k+1]){
        tree[k][0] = tree[2*k][0] + tree[2*k+1][0];
        tree[k][1] = tree[2*k][1] + tree[2*k+1][1];

        if (tree[n+m][0] == tree[n+m+1][0]){
            tree[k][1]--;
            if (tree[n+m][0])
                tree[k][0]--;
        }
    }
}

void Create2(int k, int x, int y){

    if (k >= n){
        tree[k][1] = 1;
        tree[k][0] = arr[k-n];
        return;
    }
    int m = (x + y) / 2;
    Create2(2*k, x, m);
    Create2(2*k+1, m+1, y);

    tree[k][0] = tree[2*k][0] + tree[2*k+1][0];
    tree[k][1] = tree[2*k][1] + tree[2*k+1][1];

    if (arr[m] == arr[m+1]){
        tree[k][1]--;
        if (arr[m])
            tree[k][0]--;
    }
}

void SolveForC1(){

    int t = MyLog(n);
    if ((int)pow(2, t)^n)
        while ((int)pow(2, t+1)^n)
            arr[n++] = 0;

    Create2(1, 0, n-1);

    for (int i = 0; i < q; i++){
        int l, r;
        cin >> l >> r;
        --l, --r;
        Update2(l, r, 1, 0, n-1);
        cout << tree[1][0] << '\n';
    }
}

void Solve(){

    int l, r;
    cin >> l >> r;
    --l, --r;
    for (int i = l; i <= r; i++)
        arr[i] = 1-arr[i];

    array<int, 4> dp[mxN+10];
    memset(dp, 0, sizeof(dp));

    dp[0][0] = arr[0];
    dp[0][1] = 1;
    dp[0][2] = 1-arr[0];
    dp[0][3] = 0;

    for (int i = 1; i < n; i++){
        if (arr[i]){
            int t = dp[i-1][0] + 1;
            if (dp[i-1][1] - 2 * dp[i-1][2] < 1){
                dp[i][1] = 1;
                dp[i][2] = 0;
                dp[i][3] = 0;
            }
            else {
                dp[i][1] = dp[i-1][1] + 1;
                dp[i][2] = dp[i-1][2];
                dp[i][3] = 1;
                t = min(t, dp[i-dp[i-1][1]-1][0] + c + dp[i-1][2]);
            }
            dp[i][0] = t;
        }
        else{
            dp[i][0] = dp[i-1][0];
            dp[i][1] = dp[i-1][1]+1;
            dp[i][2] = dp[i-1][2]+1;
            dp[i][3] = 0;
        }
    }

    cout << dp[n-1][0] << '\n';
}

int main(){

    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    string s;
    cin >> n >> c >> q >> s;
    for (int i = 0; i < n; i++)
        arr[i] = (int)s[i] - '0';

    if (c == n)
        SolveForCN();
    else if (c == 1)
        SolveForC1();
    else if (q == 1)
        Solve();
    else{
        for (int i = 0; i < q; i++)
            Solve();
    }

    return 0;
}